/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.shadowmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.RecipeMaker;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.AltarInfo;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeLand;
import com.lycanitesmobs.core.spawning.SpawnTypeSky;
import com.lycanitesmobs.shadowmobs.CommonSubProxy;
import com.lycanitesmobs.shadowmobs.block.BlockShadowfire;
import com.lycanitesmobs.shadowmobs.dispenser.DispenserBehaviorBloodleech;
import com.lycanitesmobs.shadowmobs.dispenser.DispenserBehaviorSpectralbolt;
import com.lycanitesmobs.shadowmobs.entity.EntityBloodleech;
import com.lycanitesmobs.shadowmobs.entity.EntityChupacabra;
import com.lycanitesmobs.shadowmobs.entity.EntityDarkling;
import com.lycanitesmobs.shadowmobs.entity.EntityEpion;
import com.lycanitesmobs.shadowmobs.entity.EntityGeist;
import com.lycanitesmobs.shadowmobs.entity.EntityGrue;
import com.lycanitesmobs.shadowmobs.entity.EntityPhantom;
import com.lycanitesmobs.shadowmobs.entity.EntityShade;
import com.lycanitesmobs.shadowmobs.entity.EntitySpectralbolt;
import com.lycanitesmobs.shadowmobs.info.AltarInfoLunarGrue;
import com.lycanitesmobs.shadowmobs.item.ItemBloodleechCharge;
import com.lycanitesmobs.shadowmobs.item.ItemGeistLiver;
import com.lycanitesmobs.shadowmobs.item.ItemScepterBloodleech;
import com.lycanitesmobs.shadowmobs.item.ItemScepterSpectralbolt;
import com.lycanitesmobs.shadowmobs.item.ItemShadowEgg;
import com.lycanitesmobs.shadowmobs.item.ItemSoulstoneShadow;
import com.lycanitesmobs.shadowmobs.item.ItemSpectralboltCharge;
import com.lycanitesmobs.shadowmobs.mobevent.MobEventBlackPlague;
import com.lycanitesmobs.shadowmobs.mobevent.MobEventShadowGames;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="shadowmobs", name="Lycanites Shadow Mobs", version="1.17.1.2 - MC 1.10.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.10.2]")
public class ShadowMobs {
    public static final String modid = "shadowmobs";
    public static final String name = "Lycanites Shadow Mobs";
    public static GroupInfo group;
    @Mod.Instance(value="shadowmobs")
    public static ShadowMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.shadowmobs.ClientSubProxy", serverSide="com.lycanitesmobs.shadowmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        group = new GroupInfo(this, "Shadow Mobs", 10).setDimensionBlacklist("1,-100").setDimensionWhitelist(true).setBiomes("END").setDungeonThemes("SHADOW, NECRO").setEggName("shadowspawn");
        group.loadFromConfig();
        ObjectManager.setCurrentGroup(group);
        ObjectManager.addItem("shadowspawn", new ItemShadowEgg());
        ObjectManager.addItem("soulstoneshadow", new ItemSoulstoneShadow(group));
        ObjectManager.addItem("spectralboltcharge", new ItemSpectralboltCharge());
        ObjectManager.addItem("spectralboltscepter", new ItemScepterSpectralbolt(), 2, 1, 1);
        ObjectManager.addItem("bloodleechcharge", new ItemBloodleechCharge());
        ObjectManager.addItem("bloodleechscepter", new ItemScepterBloodleech(), 2, 1, 1);
        ItemCustomFood rawMeat = new ItemCustomFood("chupacabrameatraw", group, 4, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76438_s, 45, 2, 0.8f);
        if (ObjectManager.getPotionEffect("fear") != null) {
            rawMeat.setPotionEffect(ObjectManager.getPotionEffect("fear"), 10, 2, 0.8f);
        }
        ObjectManager.addItem("chupacabrameatraw", (Item)rawMeat);
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("chupacabrameatraw"));
        OreDictionary.registerOre((String)"listAllmuttonraw", (Item)ObjectManager.getItem("chupacabrameatraw"));
        ItemCustomFood cookedMeat = new ItemCustomFood("chupacabrameatcooked", group, 7, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setAlwaysEdible();
        if (ObjectManager.getPotionEffect("leech") != null) {
            cookedMeat.setPotionEffect(ObjectManager.getPotionEffect("leech"), 10, 1, 1.0f);
        }
        ObjectManager.addItem("chupacabrameatcooked", (Item)cookedMeat);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("chupacabrameatcooked"));
        OreDictionary.registerOre((String)"listAllmuttoncooked", (Item)ObjectManager.getItem("chupacabrameatcooked"));
        ItemCustomFood meal = new ItemCustomFood("bloodchili", group, 7, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setAlwaysEdible();
        meal.func_77625_d(16);
        if (ObjectManager.getPotionEffect("leech") != null) {
            meal.setPotionEffect(ObjectManager.getPotionEffect("leech"), 60, 1, 1.0f);
        }
        ObjectManager.addItem("bloodchili", (Item)meal, 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("bloodchili"));
        ObjectManager.addItem("geistliver", new ItemGeistLiver());
        ObjectManager.addItem("chupacabratreat", new ItemTreat("chupacabratreat", group));
        ObjectManager.addItem("shadetreat", new ItemTreat("shadetreat", group));
        AssetManager.addSound("shadowfire", group, "block.shadowfire");
        ObjectManager.addBlock("shadowfire", new BlockShadowfire());
        RecipeMaker.addStoneBlocks(group, "shadow", Blocks.field_150343_Z);
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("shadowspawn"), (Object)new DispenserBehaviorMobEggCustom());
        MobInfo newMob = new MobInfo(group, "grue", EntityGrue.class, 1642519, 0xBB44AA).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("crimson", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon")).addSubspecies(new Subspecies("lunar", "rare"));
        newMob.spawnInfo.setSpawnTypes("UNDERGROUND, DARKNESS").setBiomes("ALL").setDimensions("-1").setDimensionWhitelist(false).setSpawnWeight(8).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "phantom", EntityPhantom.class, 1053977, 0xDD2233).setPeaceful(false).setSummonable(false).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("DEATH, SLEEP, MONSTER").setBiomes("SPOOKY").setDimensions("-1000").setDimensionWhitelist(false).setSpawnWeight(8).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        AssetManager.addSound("phantom_say_jon", group, "entity.phantom.say.jon");
        newMob = new MobInfo(group, "epion", EntityEpion.class, 0x553300, 0xFF22DD).setPeaceful(false).setSummonCost(3).setDungeonLevel(2).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("russet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER, LUNAR").setBiomes("GROUP, SPOOKY").setDimensions("-1, 1").setDimensionWhitelist(false).setSpawnWeight(6).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "geist", EntityGeist.class, 7361609, 3214856).setPeaceful(false).setSummonCost(3).setDungeonLevel(2).addSubspecies(new Subspecies("dark", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("UNDEATH, MONSTER").setBiomes("GROUP, SPOOKY").setSpawnWeight(8).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "chupacabra", EntityChupacabra.class, 3548443, 11177059).setPeaceful(true).setTameable(true).setSummonCost(3).setDungeonLevel(2).addSubspecies(new Subspecies("violet", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("UNDERGROUND").setDespawn(false).setBiomes("ALL").setDimensions("-1").setDimensionWhitelist(false).setSpawnWeight(8).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "shade", EntityShade.class, 1026, 1057590).setPeaceful(true).setTameable(true).setSummonCost(4).setDungeonLevel(3).addSubspecies(new Subspecies("keppel", "uncommon")).addSubspecies(new Subspecies("russet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("UNDERGROUND, DARKNESS").setDespawn(false).setBiomes("ALL").setDimensions("-1").setDimensionWhitelist(false).setSpawnWeight(2).setAreaLimit(2).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "darkling", EntityDarkling.class, 1055002, 10353613).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("russet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("UNDERGROUND, DARKNESS").setBiomes("ALL").setDimensions("-1").setDimensionWhitelist(false).setSpawnWeight(8).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        ObjectManager.addProjectile("spectralbolt", EntitySpectralbolt.class, ObjectManager.getItem("spectralboltcharge"), new DispenserBehaviorSpectralbolt());
        ObjectManager.addProjectile("bloodleech", EntityBloodleech.class, ObjectManager.getItem("bloodleechcharge"), new DispenserBehaviorBloodleech());
        proxy.registerModels(group);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MobInfo.loadAllFromConfigs(group);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ObjectManager.setCurrentGroup(group);
        ConfigBase config = ConfigBase.getConfig(group, "spawning");
        MobEventBase mobEvent = new MobEventShadowGames("shadowgames", group).setDimensions("-1");
        mobEvent.minDay = 10;
        SpawnTypeBase eventSpawner = new SpawnTypeSky("shadowgames_sky").setChance(1.0).setBlockLimit(32).setMobLimit(3);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("grue"));
        eventSpawner.addSpawn(MobInfo.getFromName("darkling"));
        mobEvent.addSpawner(eventSpawner);
        eventSpawner = new SpawnTypeLand("shadowgames_land").setChance(1.0).setBlockLimit(32).setMobLimit(3);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("grue"));
        eventSpawner.addSpawn(MobInfo.getFromName("shade"));
        mobEvent.addSpawner(eventSpawner);
        MobEventManager.instance.addWorldEvent(mobEvent);
        mobEvent = new MobEventBlackPlague("blackplague", group).setDimensions("-1");
        mobEvent.minDay = 10;
        eventSpawner = new SpawnTypeLand("blackplague").setChance(1.0).setBlockLimit(32).setMobLimit(8);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("geist"));
        eventSpawner.addSpawn(MobInfo.getFromName("phantom"));
        mobEvent.addSpawner(eventSpawner);
        MobEventManager.instance.addWorldEvent(mobEvent);
        AltarInfoLunarGrue lunarGrueAltar = new AltarInfoLunarGrue("LunarGrueAltar");
        AltarInfo.addAltar(lunarGrueAltar);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("bloodchili"), 1, 0), new Object[]{Items.field_151054_z, new ItemStack(Items.field_151100_aR, 1, 3), ObjectManager.getItem("chupacabrameatcooked")}));
        if (ItemInfo.enableWeaponRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("spectralboltscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("spectralboltcharge"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("bloodleechscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("bloodleechcharge"), Character.valueOf('R'), Items.field_151072_bj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("chupacabratreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("geistliver"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("shadetreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Items.field_151079_bi, Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addSmelting((Item)ObjectManager.getItem("chupacabrameatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("chupacabrameatcooked"), 1), (float)0.5f);
    }
}

